<?php
/**
 * Plugin Name: Python Executor Ultra Safe
 * Plugin URI: https://cdsconsulting.com.br/hospedagem/python-executor-ultra-safe/
 * Description: Execute scripts Python com segurança.
 * Version: 1.0.10
 * Author: CDS Consultoria
 * Author URI: https://cdsconsulting.com.br/
 * License: GPL2
 */

defined('ABSPATH') or exit;

// ========================================
// SHORTCODE PRINCIPAL
// ========================================
function python_exec_ultra_safe_shortcode($atts = []) {
    if (!current_user_can('edit_posts')) return '';

    // Captura o valor do atributo 'script' corretamente
    $args = shortcode_atts(['script' => 'print("Hello World!")'], $atts);

    // Elimina a codificação automática de entidades ou escapes desnecessários
    $processed_script = isset($args['script']) ? html_entity_decode($args['script'], ENT_QUOTES) : '';

    if (empty($processed_script)) {
        return 'Erro: O script está vazio ou não foi reconhecido.';
    }

    if (function_exists('exec')) {
        exec('python3 -c ' . escapeshellarg($processed_script) . ' 2>&1', $output);
        return implode("\n", $output);
    }

    return function_exists('shell_exec') 
        ? shell_exec('python3 -c ' . escapeshellarg($processed_script) . ' 2>&1') 
        : 'Erro: Execução de scripts não suportada pelo servidor.';
}









add_shortcode('python_exec', 'python_exec_ultra_safe_shortcode');

// ========================================
// POP-UP DE DETALHES (THICKBOX NATIVO)
// ========================================
add_action('admin_init', function() {
    add_thickbox();
});

add_action('admin_menu', function() {
    add_submenu_page(
        null,
        'Detalhes do Python Executor', 
        '', 
        'manage_options', 
        'python-executor-details', 
        'python_executor_display_popup_content'
    );
});

function python_executor_display_popup_content() {
    // Verifica se é uma chamada do Thickbox
    $is_thickbox = isset($_GET['TB_iframe']);
    
    if ($is_thickbox) {
        // Remove todas as notificações/admin notices
        remove_all_actions('admin_notices');
        remove_all_actions('all_admin_notices');
        
        // Remove a barra de admin do WordPress
        add_filter('show_admin_bar', '__return_false');
        
        // Estilo para o pop-up Thickbox
        echo '<style>
            /* Ocultar imediatamente os elementos */
            #wpadminbar, div.error {
                display: none !important;
            }
            
            /* Estilo do container do Thickbox */
            #TB_window {
                font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif;
                height: 550px !important;
                margin-top: 30px !important;
            }
            
            #TB_title {
                display: none !important;
            }
            
            #TB_ajaxContent {
                padding: 20px;
                width: 100% !important;
                height: 100% !important;
                box-sizing: border-box;
                overflow-y: auto !important;
            }
            
            #TB_closeWindowButton:focus .tb-close-icon {
                box-shadow: none !important;
            }
            
            /* Container principal */
            .python-popup-container {
                max-width: 800px;
                margin: 0 auto;
                height: 100%;
                display: flex;
                flex-direction: column;
            }
            
            /* Container das imagens */
            .python-popup-images {
                display: flex;
                justify-content: center;
                align-items: center;
                margin-bottom: 20px;
                gap: 20px;
            }
            
            /* Estilo específico para a imagem Python */
            .python-popup-images img[alt="Python"] {
                width: 350px;
                height: auto;
            }
            
            /* Estilo para a imagem do cadeado */
            .python-popup-images img[alt="Segurança"] {
                width: 150px; /* Ajuste conforme necessário */
                height: auto;
            }
            
            /* Título */
            .python-popup-title {
                text-align: center;
                margin: 0 0 20px;
                color: #23282d;
                font-size: 24px;
            }
            
            /* Blocos de código */
            .python-popup-code {
                background: #f6f7f8;
                padding: 15px;
                border-radius: 4px;
                border-left: 4px solid #0073aa;
                font-family: monospace;
                white-space: pre-wrap;
                margin: 15px 0;
            }
            
            /* Área de conteúdo */
            .python-popup-content {
                flex: 1;
                overflow-y: auto;
                padding-bottom: 20px;
            }
        </style>';
        
        // Conteúdo do pop-up
        echo '<div class="python-popup-container"><div class="python-popup-content">';
    } else {
        echo '<div class="wrap">';
    }
    ?>
        <div class="python-popup-images">
            <img src="<?php echo esc_url(plugins_url('python.png', __FILE__)); ?>" alt="Python" style="width:350px">
            <img src="<?php echo esc_url(plugins_url('cadeado.jpeg', __FILE__)); ?>" alt="Segurança">
        </div>
        
        <h1 class="python-popup-title">
            <strong>Python Executor Ultra-safe</strong>
        </h1>
        
        <p>Para executar um script Python dentro do Elementor/WordPress usando o widget Shortcode, você precisará de uma abordagem indireta, já que o WordPress (e navegadores em geral) não executam Python diretamente no front-end. No painel WordPress:</p>
        
        <div class="python-popup-code">
        Vá em "Plugins" > "Instalados"
        Ative "Python Executor Ultra Safe"</div>
        
        <p><strong>Como Usar no Elementor:</strong></p>
        
        <ol>
            <li>Adicione um widget Shortcode</li>
            <li>Insira o shortcode. Exemplos:</li>
        </ol>
        
        <div class="python-popup-code">
[python_exec script="print('Olá Elementor!')"]
[python_exec script="for i in range(1,6): print(i)"]</div>
        
        <p><strong>Requisitos:</strong></p>
        <ul>
            <li>PHP 7.4+</li>
            <li>Python 3 instalado no servidor</li>
            <li>Função <code>exec()</code> ou <code>shell_exec()</code> ativa</li>
        </ul>
    <?php
    if ($is_thickbox) {
        echo '</div></div>'; // Fecha .python-popup-content e .python-popup-container
    } else {
        echo '</div>';
    }
}

// ========================================
// FILTRO PARA ADICIONAR LINK DE DETALHES
// ========================================
add_filter('plugin_row_meta', 'python_executor_add_view_details_link', 10, 2);

function python_executor_add_view_details_link($links, $file) {
    if ($file === plugin_basename(__FILE__)) {
        // Remove o link "Ver detalhes" padrão se existir
        foreach ($links as $key => $link) {
            if (strpos($link, 'class="thickbox"') !== false) {
                unset($links[$key]);
            }
        }
        
        // Cria o link personalizado na posição correta
        $details_link = '<a href="' . esc_url(admin_url('admin.php?page=python-executor-details&TB_iframe=true&width=600&height=550')) . '" class="thickbox open-plugin-details-modal" aria-label="Mais informações sobre Python Executor Ultra Safe">Ver detalhes</a>';
        
        // Insere após a versão (posição 1)
        array_splice($links, 1, 0, $details_link);
    }
    return $links;
}

// ========================================
// SCRIPT PARA OCULTAR ELEMENTOS
// ========================================
add_action('admin_footer', function() {
    ?>
    <script>
        jQuery(document).ready(function($) {
            // Ocultar elementos imediatamente ao inicializar
            $('#wpadminbar').hide();
            $('div.error').hide();

            // Garantir ocultação após carregamento completo
            $('#TB_ajaxContent').on('load', function() {
                $('#wpadminbar').css('display', 'none');
                $('div.error').css('display', 'none');
            });
        });
    </script>
    <?php
});
